/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.startup;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.boot.context.metrics.buffering.StartupTimeline;
import org.springframework.context.annotation.ImportRuntimeHints;

@Endpoint(id="startup")
@ImportRuntimeHints(value={StartupEndpointRuntimeHints.class})
public class StartupEndpoint {
    private final BufferingApplicationStartup applicationStartup;

    public StartupEndpoint(BufferingApplicationStartup applicationStartup) {
        this.applicationStartup = applicationStartup;
    }

    @ReadOperation
    public StartupResponse startupSnapshot() {
        StartupTimeline startupTimeline = this.applicationStartup.getBufferedTimeline();
        return new StartupResponse(startupTimeline);
    }

    @WriteOperation
    public StartupResponse startup() {
        StartupTimeline startupTimeline = this.applicationStartup.drainBufferedTimeline();
        return new StartupResponse(startupTimeline);
    }

    public static final class StartupResponse {
        private final String springBootVersion;
        private final StartupTimeline timeline;

        private StartupResponse(StartupTimeline timeline) {
            this.timeline = timeline;
            this.springBootVersion = SpringBootVersion.getVersion();
        }

        public String getSpringBootVersion() {
            return this.springBootVersion;
        }

        public StartupTimeline getTimeline() {
            return this.timeline;
        }
    }

    static class StartupEndpointRuntimeHints
    implements RuntimeHintsRegistrar {
        StartupEndpointRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(TypeReference.of((String)"org.springframework.boot.context.metrics.buffering.BufferedStartupStep$DefaultTag"), hint -> hint.onReachableType(TypeReference.of((String)"org.springframework.boot.context.metrics.buffering.BufferedStartupStep")).withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}));
            hints.reflection().registerType(TypeReference.of((String)"org.springframework.core.metrics.jfr.FlightRecorderStartupStep$FlightRecorderTag"), hint -> hint.onReachableType(TypeReference.of((String)"org.springframework.core.metrics.jfr.FlightRecorderStartupStep")).withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS}));
        }
    }
}

