/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.management;

import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;

@EndpointWebExtension(endpoint=ThreadDumpEndpoint.class)
public class ThreadDumpEndpointWebExtension {
    private final ThreadDumpEndpoint delegate;

    public ThreadDumpEndpointWebExtension(ThreadDumpEndpoint delegate) {
        this.delegate = delegate;
    }

    @ReadOperation
    public WebEndpointResponse<ThreadDumpEndpoint.ThreadDumpDescriptor> threadDump() {
        try {
            return new WebEndpointResponse<ThreadDumpEndpoint.ThreadDumpDescriptor>(this.delegate.threadDump());
        }
        catch (ThreadDumpEndpoint.ThreadDumperUnavailableException ex) {
            return new WebEndpointResponse<ThreadDumpEndpoint.ThreadDumpDescriptor>(503);
        }
    }

    @ReadOperation(produces={"text/plain;charset=UTF-8"})
    public WebEndpointResponse<String> textThreadDump() {
        try {
            return new WebEndpointResponse<String>(this.delegate.textThreadDump());
        }
        catch (ThreadDumpEndpoint.ThreadDumperUnavailableException ex) {
            return new WebEndpointResponse<String>(503);
        }
    }
}

