/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.integration;

import java.lang.reflect.Type;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.aot.BindingReflectionHintsRegistrar;
import org.springframework.integration.graph.CompositeMessageHandlerNode;
import org.springframework.integration.graph.DiscardingMessageHandlerNode;
import org.springframework.integration.graph.EndpointNode;
import org.springframework.integration.graph.ErrorCapableCompositeMessageHandlerNode;
import org.springframework.integration.graph.ErrorCapableDiscardingMessageHandlerNode;
import org.springframework.integration.graph.ErrorCapableEndpointNode;
import org.springframework.integration.graph.ErrorCapableMessageHandlerNode;
import org.springframework.integration.graph.ErrorCapableRoutingNode;
import org.springframework.integration.graph.Graph;
import org.springframework.integration.graph.IntegrationGraphServer;
import org.springframework.integration.graph.MessageChannelNode;
import org.springframework.integration.graph.MessageGatewayNode;
import org.springframework.integration.graph.MessageHandlerNode;
import org.springframework.integration.graph.MessageProducerNode;
import org.springframework.integration.graph.MessageSourceNode;
import org.springframework.integration.graph.PollableChannelNode;
import org.springframework.integration.graph.RoutingMessageHandlerNode;

@Endpoint(id="integrationgraph")
@ImportRuntimeHints(value={IntegrationGraphEndpointRuntimeHints.class})
public class IntegrationGraphEndpoint {
    private final IntegrationGraphServer graphServer;

    public IntegrationGraphEndpoint(IntegrationGraphServer graphServer) {
        this.graphServer = graphServer;
    }

    @ReadOperation
    public Graph graph() {
        return this.graphServer.getGraph();
    }

    @WriteOperation
    public void rebuild() {
        this.graphServer.rebuild();
    }

    static class IntegrationGraphEndpointRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        IntegrationGraphEndpointRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Graph.class, CompositeMessageHandlerNode.class, DiscardingMessageHandlerNode.class, EndpointNode.class, ErrorCapableCompositeMessageHandlerNode.class, ErrorCapableDiscardingMessageHandlerNode.class, ErrorCapableEndpointNode.class, ErrorCapableMessageHandlerNode.class, ErrorCapableRoutingNode.class, MessageChannelNode.class, MessageGatewayNode.class, MessageHandlerNode.class, MessageProducerNode.class, MessageSourceNode.class, PollableChannelNode.class, RoutingMessageHandlerNode.class});
        }
    }
}

