/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.info;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoPropertiesInfoContributor;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.aot.BindingReflectionHintsRegistrar;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@ImportRuntimeHints(value={BuildInfoContributorRuntimeHints.class})
public class BuildInfoContributor
extends InfoPropertiesInfoContributor<BuildProperties> {
    public BuildInfoContributor(BuildProperties properties) {
        super(properties, InfoPropertiesInfoContributor.Mode.FULL);
    }

    @Override
    public void contribute(Info.Builder builder) {
        builder.withDetail("build", this.generateContent());
    }

    @Override
    protected PropertySource<?> toSimplePropertySource() {
        Properties props = new Properties();
        this.copyIfSet(props, "group");
        this.copyIfSet(props, "artifact");
        this.copyIfSet(props, "name");
        this.copyIfSet(props, "version");
        this.copyIfSet(props, "time");
        return new PropertiesPropertySource("build", props);
    }

    @Override
    protected void postProcessContent(Map<String, Object> content) {
        this.replaceValue(content, "time", ((BuildProperties)this.getProperties()).getTime());
    }

    static class BuildInfoContributorRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        BuildInfoContributorRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{BuildProperties.class});
        }
    }
}

