/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.aot.BindingReflectionHintsRegistrar;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;

@ImportRuntimeHints(value={WebMvcEndpointHandlerMappingRuntimeHints.class})
public class WebMvcEndpointHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private final EndpointLinksResolver linksResolver;

    public WebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, EndpointLinksResolver linksResolver, boolean shouldRegisterLinksMapping) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration, shouldRegisterLinksMapping);
        this.linksResolver = linksResolver;
        this.setOrder(-100);
    }

    @Override
    protected AbstractWebMvcEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return new WebMvcLinksHandler();
    }

    class WebMvcLinksHandler
    implements AbstractWebMvcEndpointHandlerMapping.LinksHandler {
        WebMvcLinksHandler() {
        }

        @Override
        @ResponseBody
        public Map<String, Map<String, Link>> links(HttpServletRequest request, HttpServletResponse response) {
            return Collections.singletonMap("_links", WebMvcEndpointHandlerMapping.this.linksResolver.resolveLinks(request.getRequestURL().toString()));
        }

        public String toString() {
            return "Actuator root web endpoint";
        }
    }

    static class WebMvcEndpointHandlerMappingRuntimeHints
    implements RuntimeHintsRegistrar {
        private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        WebMvcEndpointHandlerMappingRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerMethod(Objects.requireNonNull(ReflectionUtils.findMethod(WebMvcLinksHandler.class, (String)"links", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class})));
            this.bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Link.class});
        }
    }
}

