/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredOperationMethod;
import org.springframework.boot.actuate.endpoint.annotation.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointFilter;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.DiscoveredControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.ExposableControllerEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.MergedAnnotations;

@ImportRuntimeHints(value={ControllerEndpointDiscovererRuntimeHints.class})
public class ControllerEndpointDiscoverer
extends EndpointDiscoverer<ExposableControllerEndpoint, Operation>
implements ControllerEndpointsSupplier {
    private final List<PathMapper> endpointPathMappers;

    public ControllerEndpointDiscoverer(ApplicationContext applicationContext, List<PathMapper> endpointPathMappers, Collection<EndpointFilter<ExposableControllerEndpoint>> filters) {
        super(applicationContext, ParameterValueMapper.NONE, Collections.emptyList(), filters);
        this.endpointPathMappers = endpointPathMappers;
    }

    @Override
    protected boolean isEndpointTypeExposed(Class<?> beanType) {
        MergedAnnotations annotations = MergedAnnotations.from(beanType, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS);
        return annotations.isPresent(ControllerEndpoint.class) || annotations.isPresent(RestControllerEndpoint.class);
    }

    @Override
    protected ExposableControllerEndpoint createEndpoint(Object endpointBean, EndpointId id, boolean enabledByDefault, Collection<Operation> operations) {
        String rootPath = PathMapper.getRootPath(this.endpointPathMappers, id);
        return new DiscoveredControllerEndpoint(this, endpointBean, id, rootPath, enabledByDefault);
    }

    @Override
    protected Operation createOperation(EndpointId endpointId, DiscoveredOperationMethod operationMethod, OperationInvoker invoker) {
        throw new IllegalStateException("ControllerEndpoints must not declare operations");
    }

    @Override
    protected EndpointDiscoverer.OperationKey createOperationKey(Operation operation) {
        throw new IllegalStateException("ControllerEndpoints must not declare operations");
    }

    static class ControllerEndpointDiscovererRuntimeHints
    implements RuntimeHintsRegistrar {
        ControllerEndpointDiscovererRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(ControllerEndpointFilter.class, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
        }
    }
}

