/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.elasticsearch;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Mono;

public class ElasticsearchReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveElasticsearchClient client;

    public ElasticsearchReactiveHealthIndicator(ReactiveElasticsearchClient client) {
        super("Elasticsearch health check failed");
        this.client = client;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.client.cluster().health(b -> b).map(response -> this.processResponse(builder, (HealthResponse)response));
    }

    private Health processResponse(Health.Builder builder, HealthResponse response) {
        if (!response.timedOut()) {
            HealthStatus status = response.status();
            builder.status(HealthStatus.Red == status ? Status.OUT_OF_SERVICE : Status.UP);
            builder.withDetail("cluster_name", response.clusterName());
            builder.withDetail("status", response.status().jsonValue());
            builder.withDetail("timed_out", response.timedOut());
            builder.withDetail("number_of_nodes", response.numberOfNodes());
            builder.withDetail("number_of_data_nodes", response.numberOfDataNodes());
            builder.withDetail("active_primary_shards", response.activePrimaryShards());
            builder.withDetail("active_shards", response.activeShards());
            builder.withDetail("relocating_shards", response.relocatingShards());
            builder.withDetail("initializing_shards", response.initializingShards());
            builder.withDetail("unassigned_shards", response.unassignedShards());
            builder.withDetail("delayed_unassigned_shards", response.delayedUnassignedShards());
            builder.withDetail("number_of_pending_tasks", response.numberOfPendingTasks());
            builder.withDetail("number_of_in_flight_fetch", response.numberOfInFlightFetch());
            builder.withDetail("task_max_waiting_in_queue_millis", response.taskMaxWaitingInQueueMillis().toEpochMilli());
            builder.withDetail("active_shards_percent_as_number", Double.parseDouble(response.activeShardsPercentAsNumber()));
            return builder.build();
        }
        return builder.down().build();
    }
}

