/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.boot.actuate.metrics.export.prometheus.TextOutputFormat;
import org.springframework.lang.Nullable;

@WebEndpoint(id="prometheus")
public class PrometheusScrapeEndpoint {
    private final CollectorRegistry collectorRegistry;

    public PrometheusScrapeEndpoint(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @ReadOperation(producesFrom=TextOutputFormat.class)
    public WebEndpointResponse<String> scrape(TextOutputFormat format, @Nullable Set<String> includedNames) {
        try {
            StringWriter writer = new StringWriter();
            Enumeration samples = includedNames != null ? this.collectorRegistry.filteredMetricFamilySamples(includedNames) : this.collectorRegistry.metricFamilySamples();
            format.write(writer, samples);
            return new WebEndpointResponse<String>(((Object)writer).toString(), format);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Writing metrics failed", ex);
        }
    }
}

