/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class CassandraDriverReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final SimpleStatement SELECT = (SimpleStatement)SimpleStatement.newInstance((String)"SELECT release_version FROM system.local").setConsistencyLevel(ConsistencyLevel.LOCAL_ONE);
    private final CqlSession session;

    public CassandraDriverReactiveHealthIndicator(CqlSession session) {
        super("Cassandra health check failed");
        Assert.notNull((Object)session, (String)"session must not be null");
        this.session = session;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return Mono.from((Publisher)this.session.executeReactive((Statement)SELECT)).map(row -> builder.up().withDetail("version", row.getString(0)).build());
    }
}

