/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class CassandraDriverHealthIndicator
extends AbstractHealthIndicator {
    private static final SimpleStatement SELECT = (SimpleStatement)SimpleStatement.newInstance((String)"SELECT release_version FROM system.local").setConsistencyLevel(ConsistencyLevel.LOCAL_ONE);
    private final CqlSession session;

    public CassandraDriverHealthIndicator(CqlSession session) {
        super("Cassandra health check failed");
        Assert.notNull((Object)session, (String)"session must not be null");
        this.session = session;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Row row = (Row)this.session.execute((Statement)SELECT).one();
        builder.up();
        if (row != null && !row.isNull(0)) {
            builder.withDetail("version", row.getString(0));
        }
    }
}

