/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.redis;

import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.util.Assert;

public class RedisHealthIndicator
extends AbstractHealthIndicator {
    private static final String REDIS_VERSION_PROPERTY = "redis_version";
    private final RedisConnectionFactory redisConnectionFactory;

    public RedisHealthIndicator(RedisConnectionFactory connectionFactory) {
        super("Redis health check failed");
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        this.redisConnectionFactory = connectionFactory;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        RedisConnection connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
        try {
            this.doHealthCheck(builder, connection);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisConnectionFactory, (boolean)false);
        }
    }

    private void doHealthCheck(Health.Builder builder, RedisConnection connection) {
        if (connection instanceof RedisClusterConnection) {
            ClusterInfo clusterInfo = ((RedisClusterConnection)connection).clusterGetClusterInfo();
            builder.up().withDetail("cluster_size", clusterInfo.getClusterSize()).withDetail("slots_up", clusterInfo.getSlotsOk()).withDetail("slots_fail", clusterInfo.getSlotsFail());
        } else {
            String version = connection.info().getProperty(REDIS_VERSION_PROPERTY);
            builder.up().withDetail("version", version);
        }
    }
}

