/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.DefaultReactiveHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorNameFactory;
import org.springframework.boot.actuate.health.HealthIndicatorReactiveAdapter;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Deprecated
public class ReactiveHealthIndicatorRegistryFactory {
    private final Function<String, String> healthIndicatorNameFactory;

    public ReactiveHealthIndicatorRegistryFactory(Function<String, String> healthIndicatorNameFactory) {
        this.healthIndicatorNameFactory = healthIndicatorNameFactory;
    }

    public ReactiveHealthIndicatorRegistryFactory() {
        this(new HealthIndicatorNameFactory());
    }

    public ReactiveHealthIndicatorRegistry createReactiveHealthIndicatorRegistry(Map<String, ReactiveHealthIndicator> reactiveHealthIndicators, Map<String, HealthIndicator> healthIndicators) {
        Assert.notNull(reactiveHealthIndicators, (String)"ReactiveHealthIndicators must not be null");
        return this.initialize(new DefaultReactiveHealthIndicatorRegistry(), reactiveHealthIndicators, healthIndicators);
    }

    protected <T extends ReactiveHealthIndicatorRegistry> T initialize(T registry, Map<String, ReactiveHealthIndicator> reactiveHealthIndicators, Map<String, HealthIndicator> healthIndicators) {
        this.merge(reactiveHealthIndicators, healthIndicators).forEach((beanName, indicator) -> {
            String name = this.healthIndicatorNameFactory.apply((String)beanName);
            registry.register(name, (ReactiveHealthIndicator)indicator);
        });
        return registry;
    }

    private Map<String, ReactiveHealthIndicator> merge(Map<String, ReactiveHealthIndicator> reactiveHealthIndicators, Map<String, HealthIndicator> healthIndicators) {
        if (ObjectUtils.isEmpty(healthIndicators)) {
            return reactiveHealthIndicators;
        }
        LinkedHashMap<String, ReactiveHealthIndicator> allIndicators = new LinkedHashMap<String, ReactiveHealthIndicator>(reactiveHealthIndicators);
        healthIndicators.forEach((beanName, indicator) -> {
            String name = this.healthIndicatorNameFactory.apply((String)beanName);
            allIndicators.computeIfAbsent(name, n -> new HealthIndicatorReactiveAdapter((HealthIndicator)indicator));
        });
        return allIndicators;
    }
}

