/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.security.Principal;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.ShowDetails;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Deprecated
public class HealthWebEndpointResponseMapper {
    private final HealthStatusHttpMapper statusHttpMapper;
    private final ShowDetails showDetails;
    private final Set<String> authorizedRoles;

    public HealthWebEndpointResponseMapper(HealthStatusHttpMapper statusHttpMapper, ShowDetails showDetails, Set<String> authorizedRoles) {
        this.statusHttpMapper = statusHttpMapper;
        this.showDetails = showDetails;
        this.authorizedRoles = authorizedRoles;
    }

    public WebEndpointResponse<Health> mapDetails(Supplier<Health> health, SecurityContext securityContext) {
        Health healthDetails;
        if (this.canSeeDetails(securityContext, this.showDetails) && (healthDetails = health.get()) != null) {
            return this.createWebEndpointResponse(healthDetails);
        }
        return new WebEndpointResponse<Health>(404);
    }

    public WebEndpointResponse<Health> map(Health health, SecurityContext securityContext) {
        return this.map(health, securityContext, this.showDetails);
    }

    public WebEndpointResponse<Health> map(Health health, SecurityContext securityContext, ShowDetails showDetails) {
        if (!this.canSeeDetails(securityContext, showDetails)) {
            health = Health.status(health.getStatus()).build();
        }
        return this.createWebEndpointResponse(health);
    }

    private WebEndpointResponse<Health> createWebEndpointResponse(Health health) {
        Integer status = this.statusHttpMapper.mapStatus(health.getStatus());
        return new WebEndpointResponse<Health>(health, status);
    }

    private boolean canSeeDetails(SecurityContext securityContext, ShowDetails showDetails) {
        return showDetails != ShowDetails.NEVER && (showDetails != ShowDetails.WHEN_AUTHORIZED || securityContext.getPrincipal() != null && this.isUserInRole(securityContext));
    }

    private boolean isUserInRole(SecurityContext securityContext) {
        if (CollectionUtils.isEmpty(this.authorizedRoles)) {
            return true;
        }
        Principal principal = securityContext.getPrincipal();
        boolean checkAuthorities = this.isSpringSecurityAuthentication(principal);
        for (String role : this.authorizedRoles) {
            if (securityContext.isUserInRole(role)) {
                return true;
            }
            if (!checkAuthorities) continue;
            Authentication authentication = (Authentication)principal;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                String name = authority.getAuthority();
                if (!role.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringSecurityAuthentication(Principal principal) {
        return ClassUtils.isPresent((String)"org.springframework.security.core.Authentication", null) && principal instanceof Authentication;
    }
}

