/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.web.reactive.client.WebClientExchangeTagsProvider;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class MetricsWebClientFilterFunction
implements ExchangeFilterFunction {
    private static final String METRICS_WEBCLIENT_START_TIME = MetricsWebClientFilterFunction.class.getName() + ".START_TIME";
    private final MeterRegistry meterRegistry;
    private final WebClientExchangeTagsProvider tagProvider;
    private final String metricName;
    private final AutoTimer autoTimer;

    @Deprecated
    public MetricsWebClientFilterFunction(MeterRegistry meterRegistry, WebClientExchangeTagsProvider tagProvider, String metricName) {
        this(meterRegistry, tagProvider, metricName, AutoTimer.ENABLED);
    }

    public MetricsWebClientFilterFunction(MeterRegistry meterRegistry, WebClientExchangeTagsProvider tagProvider, String metricName, AutoTimer autoTimer) {
        this.meterRegistry = meterRegistry;
        this.tagProvider = tagProvider;
        this.metricName = metricName;
        this.autoTimer = autoTimer != null ? autoTimer : AutoTimer.DISABLED;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        if (!this.autoTimer.isEnabled()) {
            return next.exchange(request);
        }
        return next.exchange(request).doOnEach(signal -> {
            if (!signal.isOnComplete()) {
                Long startTime = this.getStartTime(signal.getContext());
                ClientResponse response = (ClientResponse)signal.get();
                Throwable throwable = signal.getThrowable();
                Iterable<Tag> tags = this.tagProvider.tags(request, response, throwable);
                this.autoTimer.builder(this.metricName).tags(tags).description("Timer of WebClient operation").register(this.meterRegistry).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            }
        }).subscriberContext(this::putStartTime);
    }

    private Long getStartTime(Context context) {
        return (Long)context.get((Object)METRICS_WEBCLIENT_START_TIME);
    }

    private Context putStartTime(Context context) {
        return context.put((Object)METRICS_WEBCLIENT_START_TIME, (Object)System.nanoTime());
    }
}

