/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class CassandraReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final Statement SELECT = new SimpleStatement("SELECT release_version FROM system.local").setConsistencyLevel(ConsistencyLevel.LOCAL_ONE);
    private final ReactiveCassandraOperations reactiveCassandraOperations;

    public CassandraReactiveHealthIndicator(ReactiveCassandraOperations reactiveCassandraOperations) {
        super("Cassandra health check failed");
        Assert.notNull((Object)reactiveCassandraOperations, (String)"ReactiveCassandraOperations must not be null");
        this.reactiveCassandraOperations = reactiveCassandraOperations;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.reactiveCassandraOperations.getReactiveCqlOperations().queryForObject(SELECT, String.class).map(version -> builder.up().withDetail("version", version).build()).single();
    }
}

