/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.client;

import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;

public final class WebClientExchangeTags {
    private static final String URI_TEMPLATE_ATTRIBUTE = WebClient.class.getName() + ".uriTemplate";
    private static final Tag IO_ERROR = Tag.of((String)"status", (String)"IO_ERROR");
    private static final Tag CLIENT_ERROR = Tag.of((String)"status", (String)"CLIENT_ERROR");
    private static final Pattern PATTERN_BEFORE_PATH = Pattern.compile("^https?://[^/]+/");
    private static final Tag CLIENT_NAME_NONE = Tag.of((String)"clientName", (String)"none");
    private static final Tag OUTCOME_UNKNOWN = Tag.of((String)"outcome", (String)"UNKNOWN");
    private static final Tag OUTCOME_INFORMATIONAL = Tag.of((String)"outcome", (String)"INFORMATIONAL");
    private static final Tag OUTCOME_SUCCESS = Tag.of((String)"outcome", (String)"SUCCESS");
    private static final Tag OUTCOME_REDIRECTION = Tag.of((String)"outcome", (String)"REDIRECTION");
    private static final Tag OUTCOME_CLIENT_ERROR = Tag.of((String)"outcome", (String)"CLIENT_ERROR");
    private static final Tag OUTCOME_SERVER_ERROR = Tag.of((String)"outcome", (String)"SERVER_ERROR");

    private WebClientExchangeTags() {
    }

    public static Tag method(ClientRequest request) {
        return Tag.of((String)"method", (String)request.method().name());
    }

    public static Tag uri(ClientRequest request) {
        String uri = (String)request.attribute(URI_TEMPLATE_ATTRIBUTE).orElseGet(() -> request.url().getPath());
        return Tag.of((String)"uri", (String)WebClientExchangeTags.extractPath(uri));
    }

    private static String extractPath(String url) {
        String path = PATTERN_BEFORE_PATH.matcher(url).replaceFirst("");
        return path.startsWith("/") ? path : "/" + path;
    }

    public static Tag status(ClientResponse response) {
        return Tag.of((String)"status", (String)String.valueOf(response.statusCode().value()));
    }

    public static Tag status(Throwable throwable) {
        return throwable instanceof IOException ? IO_ERROR : CLIENT_ERROR;
    }

    public static Tag clientName(ClientRequest request) {
        String host = request.url().getHost();
        if (host == null) {
            return CLIENT_NAME_NONE;
        }
        return Tag.of((String)"clientName", (String)host);
    }

    public static Tag outcome(ClientResponse response) {
        try {
            if (response != null) {
                HttpStatus status = response.statusCode();
                if (status.is1xxInformational()) {
                    return OUTCOME_INFORMATIONAL;
                }
                if (status.is2xxSuccessful()) {
                    return OUTCOME_SUCCESS;
                }
                if (status.is3xxRedirection()) {
                    return OUTCOME_REDIRECTION;
                }
                if (status.is4xxClientError()) {
                    return OUTCOME_CLIENT_ERROR;
                }
                if (status.is5xxServerError()) {
                    return OUTCOME_SERVER_ERROR;
                }
            }
            return OUTCOME_UNKNOWN;
        }
        catch (IllegalArgumentException exc) {
            return OUTCOME_UNKNOWN;
        }
    }
}

