/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.redis;

import java.util.Properties;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RedisReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveRedisConnectionFactory connectionFactory;

    public RedisReactiveHealthIndicator(ReactiveRedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.getConnection().flatMap(connection -> this.doHealthCheck(builder, (ReactiveRedisConnection)connection));
    }

    private Mono<Health> doHealthCheck(Health.Builder builder, ReactiveRedisConnection connection) {
        return connection.serverCommands().info().map(info -> this.up(builder, (Properties)info)).onErrorResume(ex -> Mono.just((Object)this.down(builder, (Throwable)ex))).flatMap(health -> connection.closeLater().thenReturn(health));
    }

    private Mono<ReactiveRedisConnection> getConnection() {
        return Mono.fromSupplier(() -> ((ReactiveRedisConnectionFactory)this.connectionFactory).getReactiveConnection()).subscribeOn(Schedulers.parallel());
    }

    private Health up(Health.Builder builder, Properties info) {
        return builder.up().withDetail("version", info.getProperty("redis_version")).build();
    }

    private Health down(Health.Builder builder, Throwable cause) {
        return builder.down(cause).build();
    }
}

