/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthStatusHttpMapper;
import org.springframework.boot.actuate.health.ShowDetails;
import org.springframework.util.CollectionUtils;

public class HealthWebEndpointResponseMapper {
    private final HealthStatusHttpMapper statusHttpMapper;
    private final ShowDetails showDetails;
    private final Set<String> authorizedRoles;

    public HealthWebEndpointResponseMapper(HealthStatusHttpMapper statusHttpMapper, ShowDetails showDetails, Set<String> authorizedRoles) {
        this.statusHttpMapper = statusHttpMapper;
        this.showDetails = showDetails;
        this.authorizedRoles = authorizedRoles;
    }

    public WebEndpointResponse<Health> mapDetails(Supplier<Health> health, SecurityContext securityContext) {
        Health healthDetails;
        if (this.canSeeDetails(securityContext, this.showDetails) && (healthDetails = health.get()) != null) {
            return this.createWebEndpointResponse(healthDetails);
        }
        return new WebEndpointResponse<Health>(404);
    }

    public WebEndpointResponse<Health> map(Health health, SecurityContext securityContext) {
        return this.map(health, securityContext, this.showDetails);
    }

    public WebEndpointResponse<Health> map(Health health, SecurityContext securityContext, ShowDetails showDetails) {
        if (showDetails == ShowDetails.NEVER || showDetails == ShowDetails.WHEN_AUTHORIZED && (securityContext.getPrincipal() == null || !this.isUserInRole(securityContext))) {
            health = Health.status(health.getStatus()).build();
        }
        return this.createWebEndpointResponse(health);
    }

    private WebEndpointResponse<Health> createWebEndpointResponse(Health health) {
        Integer status = this.statusHttpMapper.mapStatus(health.getStatus());
        return new WebEndpointResponse<Health>(health, status);
    }

    private boolean canSeeDetails(SecurityContext securityContext, ShowDetails showDetails) {
        return showDetails != ShowDetails.NEVER && (showDetails != ShowDetails.WHEN_AUTHORIZED || securityContext.getPrincipal() != null && this.isUserInRole(securityContext));
    }

    private boolean isUserInRole(SecurityContext securityContext) {
        if (CollectionUtils.isEmpty(this.authorizedRoles)) {
            return true;
        }
        for (String role : this.authorizedRoles) {
            if (!securityContext.isUserInRole(role)) continue;
            return true;
        }
        return false;
    }
}

