/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PrometheusPushGatewayManager {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusPushGatewayManager.class);
    private final PushGateway pushGateway;
    private final CollectorRegistry registry;
    private final String job;
    private final Map<String, String> groupingKey;
    private final ShutdownOperation shutdownOperation;
    private final TaskScheduler scheduler;
    private ScheduledFuture<?> scheduled;

    public PrometheusPushGatewayManager(PushGateway pushGateway, CollectorRegistry registry, Duration pushRate, String job, Map<String, String> groupingKeys, ShutdownOperation shutdownOperation) {
        this(pushGateway, registry, (TaskScheduler)new PushGatewayTaskScheduler(), pushRate, job, groupingKeys, shutdownOperation);
    }

    public PrometheusPushGatewayManager(PushGateway pushGateway, CollectorRegistry registry, TaskScheduler scheduler, Duration pushRate, String job, Map<String, String> groupingKey, ShutdownOperation shutdownOperation) {
        Assert.notNull((Object)pushGateway, (String)"PushGateway must not be null");
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        Assert.notNull((Object)scheduler, (String)"Scheduler must not be null");
        Assert.notNull((Object)pushRate, (String)"PushRate must not be null");
        Assert.hasLength((String)job, (String)"Job must not be empty");
        this.pushGateway = pushGateway;
        this.registry = registry;
        this.job = job;
        this.groupingKey = groupingKey;
        this.shutdownOperation = shutdownOperation != null ? shutdownOperation : ShutdownOperation.NONE;
        this.scheduler = scheduler;
        this.scheduled = this.scheduler.scheduleAtFixedRate(this::push, pushRate);
    }

    private void push() {
        try {
            this.pushGateway.pushAdd(this.registry, this.job, this.groupingKey);
        }
        catch (UnknownHostException ex) {
            String host = ex.getMessage();
            String message = "Unable to locate prometheus push gateway host";
            message = message + (StringUtils.hasLength((String)host) ? " '" + host + "'" : "");
            message = message + ". No longer attempting metrics publication to this host";
            logger.error(message, (Throwable)ex);
            this.shutdown(ShutdownOperation.NONE);
        }
        catch (Throwable ex) {
            logger.error("Unable to push metrics to Prometheus Pushgateway", ex);
        }
    }

    private void delete() {
        try {
            this.pushGateway.delete(this.job, this.groupingKey);
        }
        catch (Throwable ex) {
            logger.error("Unable to delete metrics from Prometheus Pushgateway", ex);
        }
    }

    public void shutdown() {
        this.shutdown(this.shutdownOperation);
    }

    private void shutdown(ShutdownOperation shutdownOperation) {
        if (this.scheduler instanceof PushGatewayTaskScheduler) {
            ((PushGatewayTaskScheduler)this.scheduler).shutdown();
        }
        this.scheduled.cancel(false);
        switch (shutdownOperation) {
            case PUSH: {
                this.push();
                break;
            }
            case DELETE: {
                this.delete();
            }
        }
    }

    static class PushGatewayTaskScheduler
    extends ThreadPoolTaskScheduler {
        PushGatewayTaskScheduler() {
            this.setPoolSize(1);
            this.setDaemon(true);
            this.setThreadGroupName("prometheus-push-gateway");
        }

        public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
            return Executors.newSingleThreadScheduledExecutor(arg_0 -> ((PushGatewayTaskScheduler)this).newThread(arg_0));
        }
    }

    public static enum ShutdownOperation {
        NONE,
        PUSH,
        DELETE;

    }
}

