/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.Status;
import org.springframework.util.Assert;

public class HealthStatusHttpMapper {
    private Map<String, Integer> statusMapping = new HashMap<String, Integer>();

    public HealthStatusHttpMapper() {
        this.setupDefaultStatusMapping();
    }

    private void setupDefaultStatusMapping() {
        this.addStatusMapping(Status.DOWN, (Integer)503);
        this.addStatusMapping(Status.OUT_OF_SERVICE, (Integer)503);
    }

    public void setStatusMapping(Map<String, Integer> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping = new HashMap<String, Integer>(statusMapping);
    }

    public void addStatusMapping(Map<String, Integer> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping.putAll(statusMapping);
    }

    public void addStatusMapping(Status status, Integer httpStatus) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.addStatusMapping(status.getCode(), httpStatus);
    }

    public void addStatusMapping(String statusCode, Integer httpStatus) {
        Assert.notNull((Object)statusCode, (String)"StatusCode must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.statusMapping.put(statusCode, httpStatus);
    }

    public Map<String, Integer> getStatusMapping() {
        return Collections.unmodifiableMap(this.statusMapping);
    }

    public int mapStatus(Status status) {
        String code = this.getUniformValue(status.getCode());
        if (code != null) {
            return this.statusMapping.keySet().stream().filter(key -> code.equals(this.getUniformValue((String)key))).map(this.statusMapping::get).findFirst().orElse(200);
        }
        return 200;
    }

    private String getUniformValue(String code) {
        if (code == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (char ch : code.toCharArray()) {
            if (!Character.isAlphabetic(ch) && !Character.isDigit(ch)) continue;
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }
}

