/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.web.EndpointServlet;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.Assert;

public class ServletEndpointRegistrar
implements ServletContextInitializer {
    private static final Log logger = LogFactory.getLog(ServletEndpointRegistrar.class);
    private final String basePath;
    private final Collection<ExposableServletEndpoint> servletEndpoints;

    public ServletEndpointRegistrar(String basePath, Collection<ExposableServletEndpoint> servletEndpoints) {
        Assert.notNull(servletEndpoints, (String)"ServletEndpoints must not be null");
        this.basePath = basePath != null ? basePath : "";
        this.servletEndpoints = servletEndpoints;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.servletEndpoints.forEach(servletEndpoint -> this.register(servletContext, (ExposableServletEndpoint)servletEndpoint));
    }

    private void register(ServletContext servletContext, ExposableServletEndpoint endpoint) {
        String name = endpoint.getId() + "-actuator-endpoint";
        String path = this.basePath + "/" + endpoint.getRootPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        EndpointServlet endpointServlet = endpoint.getEndpointServlet();
        ServletRegistration.Dynamic registration = servletContext.addServlet(name, endpointServlet.getServlet());
        registration.addMapping(new String[]{urlMapping});
        registration.setInitParameters(endpointServlet.getInitParameters());
        logger.info((Object)("Registered '" + path + "' to " + name));
    }
}

