/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.trace;

import java.util.List;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.trace.Trace;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.util.Assert;

@Endpoint(id="trace")
public class TraceEndpoint {
    private final TraceRepository repository;

    public TraceEndpoint(TraceRepository repository) {
        Assert.notNull((Object)repository, (String)"Repository must not be null");
        this.repository = repository;
    }

    @ReadOperation
    public TraceDescriptor traces() {
        return new TraceDescriptor(this.repository.findAll());
    }

    public static final class TraceDescriptor {
        private final List<Trace> traces;

        private TraceDescriptor(List<Trace> traces) {
            this.traces = traces;
        }

        public List<Trace> getTraces() {
            return this.traces;
        }
    }
}

