/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.neo4j;

import java.util.Collections;
import java.util.Map;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class Neo4jHealthIndicator
extends AbstractHealthIndicator {
    static final String CYPHER = "match (n) return count(n) as nodes";
    private final SessionFactory sessionFactory;

    public Neo4jHealthIndicator(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Session session = this.sessionFactory.openSession();
        Result result = session.query(CYPHER, Collections.emptyMap());
        builder.up().withDetail("nodes", ((Map)((Iterable)result.queryResults()).iterator().next()).get("nodes"));
    }
}

