/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.liquibase;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Endpoint(id="liquibase")
public class LiquibaseEndpoint {
    private final Map<String, SpringLiquibase> liquibaseBeans;

    public LiquibaseEndpoint(Map<String, SpringLiquibase> liquibaseBeans) {
        Assert.notEmpty(liquibaseBeans, (String)"LiquibaseBeans must be specified");
        this.liquibaseBeans = liquibaseBeans;
    }

    @ReadOperation
    public Map<String, LiquibaseReport> liquibaseReports() {
        HashMap<String, LiquibaseReport> reports = new HashMap<String, LiquibaseReport>();
        DatabaseFactory factory = DatabaseFactory.getInstance();
        StandardChangeLogHistoryService service = new StandardChangeLogHistoryService();
        this.liquibaseBeans.forEach((name, liquibase) -> reports.put((String)name, this.createReport((SpringLiquibase)liquibase, (ChangeLogHistoryService)service, factory)));
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LiquibaseReport createReport(SpringLiquibase liquibase, ChangeLogHistoryService service, DatabaseFactory factory) {
        LiquibaseReport liquibaseReport;
        DataSource dataSource = liquibase.getDataSource();
        JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
        try {
            Database database = factory.findCorrectDatabaseImplementation((DatabaseConnection)connection);
            String defaultSchema = liquibase.getDefaultSchema();
            if (StringUtils.hasText((String)defaultSchema)) {
                database.setDefaultSchemaName(defaultSchema);
            }
            service.setDatabase(database);
            liquibaseReport = new LiquibaseReport(service.getRanChangeSets().stream().map(ChangeSet::new).collect(Collectors.toList()));
        }
        catch (Throwable throwable) {
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to get Liquibase change sets", ex);
            }
        }
        connection.close();
        return liquibaseReport;
    }

    public static class ContextExpression {
        private final Set<String> contexts;

        public ContextExpression(Set<String> contexts) {
            this.contexts = contexts;
        }

        public Set<String> getContexts() {
            return this.contexts;
        }
    }

    public static class ChangeSet {
        private final String author;
        private final String changeLog;
        private final String comments;
        private final Set<String> contexts;
        private final Date dateExecuted;
        private final String deploymentId;
        private final String description;
        private final ChangeSet.ExecType execType;
        private final String id;
        private final Set<String> labels;
        private final String checksum;
        private final Integer orderExecuted;
        private final String tag;

        public ChangeSet(RanChangeSet ranChangeSet) {
            this.author = ranChangeSet.getAuthor();
            this.changeLog = ranChangeSet.getChangeLog();
            this.comments = ranChangeSet.getComments();
            this.contexts = ranChangeSet.getContextExpression().getContexts();
            this.dateExecuted = ranChangeSet.getDateExecuted();
            this.deploymentId = ranChangeSet.getDeploymentId();
            this.description = ranChangeSet.getDescription();
            this.execType = ranChangeSet.getExecType();
            this.id = ranChangeSet.getId();
            this.labels = ranChangeSet.getLabels().getLabels();
            this.checksum = ranChangeSet.getLastCheckSum() == null ? null : ranChangeSet.getLastCheckSum().toString();
            this.orderExecuted = ranChangeSet.getOrderExecuted();
            this.tag = ranChangeSet.getTag();
        }

        public String getAuthor() {
            return this.author;
        }

        public String getChangeLog() {
            return this.changeLog;
        }

        public String getComments() {
            return this.comments;
        }

        public Set<String> getContexts() {
            return this.contexts;
        }

        public Date getDateExecuted() {
            return this.dateExecuted;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public String getDescription() {
            return this.description;
        }

        public ChangeSet.ExecType getExecType() {
            return this.execType;
        }

        public String getId() {
            return this.id;
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public Integer getOrderExecuted() {
            return this.orderExecuted;
        }

        public String getTag() {
            return this.tag;
        }
    }

    public static class LiquibaseReport {
        private final List<ChangeSet> changeSets;

        public LiquibaseReport(List<ChangeSet> changeSets) {
            this.changeSets = changeSets;
        }

        public List<ChangeSet> getChangeSets() {
            return this.changeSets;
        }
    }
}

