/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.actuate.endpoint.web.WebEndpointHttpMethod;
import org.springframework.core.style.ToStringCreator;

public class OperationRequestPredicate {
    private final String path;
    private final String canonicalPath;
    private final WebEndpointHttpMethod httpMethod;
    private final Collection<String> consumes;
    private final Collection<String> produces;

    public OperationRequestPredicate(String path, WebEndpointHttpMethod httpMethod, Collection<String> consumes, Collection<String> produces) {
        this.path = path;
        this.canonicalPath = path.replaceAll("\\{.*?}", "{*}");
        this.httpMethod = httpMethod;
        this.consumes = consumes;
        this.produces = produces;
    }

    public String getPath() {
        return this.path;
    }

    public WebEndpointHttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Collection<String> getConsumes() {
        return Collections.unmodifiableCollection(this.consumes);
    }

    public Collection<String> getProduces() {
        return Collections.unmodifiableCollection(this.produces);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("httpMethod", (Object)this.httpMethod).append("path", (Object)this.path).append("consumes", this.consumes).append("produces", this.produces).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.consumes.hashCode();
        result = 31 * result + this.httpMethod.hashCode();
        result = 31 * result + this.canonicalPath.hashCode();
        result = 31 * result + this.produces.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OperationRequestPredicate other = (OperationRequestPredicate)obj;
        boolean result = true;
        result = result && this.consumes.equals(other.consumes);
        result = result && this.httpMethod == other.httpMethod;
        result = result && this.canonicalPath.equals(other.canonicalPath);
        result = result && this.produces.equals(other.produces);
        return result;
    }
}

