/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInfo;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.boot.actuate.endpoint.reflect.ParametersMissingException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectiveOperationInvoker
implements OperationInvoker {
    private final Object target;
    private final OperationMethodInfo methodInfo;
    private final ParameterMapper parameterMapper;

    public ReflectiveOperationInvoker(Object target, OperationMethodInfo methodInfo, ParameterMapper parameterMapper) {
        Assert.notNull((Object)target, (String)"Target must not be null");
        Assert.notNull((Object)methodInfo, (String)"MethodInfo must not be null");
        Assert.notNull((Object)parameterMapper, (String)"ParameterMapper must not be null");
        ReflectionUtils.makeAccessible((Method)methodInfo.getMethod());
        this.target = target;
        this.methodInfo = methodInfo;
        this.parameterMapper = parameterMapper;
    }

    @Override
    public Object invoke(Map<String, Object> arguments) {
        Map<String, Parameter> parameters = this.methodInfo.getParameters();
        this.validateRequiredParameters(parameters, arguments);
        return ReflectionUtils.invokeMethod((Method)this.methodInfo.getMethod(), (Object)this.target, (Object[])this.resolveArguments(parameters, arguments));
    }

    private void validateRequiredParameters(Map<String, Parameter> parameters, Map<String, Object> arguments) {
        Set<String> missingParameters = parameters.keySet().stream().filter(n -> this.isMissing((String)n, (Parameter)parameters.get(n), arguments)).collect(Collectors.toSet());
        if (!missingParameters.isEmpty()) {
            throw new ParametersMissingException(missingParameters);
        }
    }

    private boolean isMissing(String name, Parameter parameter, Map<String, Object> arguments) {
        Object resolved = arguments.get(name);
        return resolved == null && !this.isExplicitNullable(parameter);
    }

    private boolean isExplicitNullable(Parameter parameter) {
        return ((Nullable[])parameter.getAnnotationsByType(Nullable.class)).length != 0;
    }

    private Object[] resolveArguments(Map<String, Parameter> parameters, Map<String, Object> arguments) {
        return parameters.keySet().stream().map(name -> this.resolveArgument((String)name, (Parameter)parameters.get(name), arguments)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.toArray(new Object[list.size()])));
    }

    private Object resolveArgument(String name, Parameter parameter, Map<String, Object> arguments) {
        Object resolved = arguments.get(name);
        return this.parameterMapper.mapParameter(resolved, parameter.getType());
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("target", this.target).append("method", (Object)this.methodInfo.getMethod().toString()).toString();
    }
}

