/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.util.Assert;

public final class OperationMethodInfo {
    private static final ParameterNameDiscoverer DEFAULT_PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private final Method method;
    private final OperationType operationType;
    private final AnnotationAttributes annotationAttributes;
    private final ParameterNameDiscoverer parameterNameDiscoverer = DEFAULT_PARAMETER_NAME_DISCOVERER;

    public OperationMethodInfo(Method method, OperationType operationType, AnnotationAttributes annotationAttributes) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)((Object)operationType), (String)"Operation Type must not be null");
        Assert.notNull((Object)annotationAttributes, (String)"Annotation Attributes must not be null");
        this.method = method;
        this.operationType = operationType;
        this.annotationAttributes = annotationAttributes;
    }

    public Method getMethod() {
        return this.method;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String[] getProduces() {
        return this.annotationAttributes.getStringArray("produces");
    }

    public Map<String, Parameter> getParameters() {
        Parameter[] parameters = this.method.getParameters();
        String[] names = this.parameterNameDiscoverer.getParameterNames(this.method);
        Assert.state((names != null ? 1 : 0) != 0, (String)("Failed to extract parameter names for " + this.method));
        LinkedHashMap<String, Parameter> result = new LinkedHashMap<String, Parameter>();
        for (int i = 0; i < names.length; ++i) {
            result.put(names[i], parameters[i]);
        }
        return result;
    }
}

