/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanInfo;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanInfoAssembler;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxOperationResponseMapper;

public class JmxEndpointMBeanFactory {
    private final EndpointMBeanInfoAssembler assembler;
    private final JmxOperationResponseMapper resultMapper;

    public JmxEndpointMBeanFactory(JmxOperationResponseMapper responseMapper) {
        this.assembler = new EndpointMBeanInfoAssembler(responseMapper);
        this.resultMapper = responseMapper;
    }

    public Collection<EndpointMBean> createMBeans(Collection<EndpointInfo<JmxOperation>> endpoints) {
        return endpoints.stream().map(this::createMBean).collect(Collectors.toList());
    }

    private EndpointMBean createMBean(EndpointInfo<JmxOperation> endpointInfo) {
        EndpointMBeanInfo endpointMBeanInfo = this.assembler.createEndpointMBeanInfo(endpointInfo);
        return new EndpointMBean(this.resultMapper::mapResponse, endpointMBeanInfo);
    }
}

