/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.convert;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.util.StringUtils;

public class IsoOffsetDateTimeConverter
implements Converter<String, Date> {
    public Date convert(String source) {
        if (StringUtils.hasLength((String)source)) {
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(source, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return new Date(TimeUnit.SECONDS.toMillis(offsetDateTime.toEpochSecond()));
        }
        return null;
    }

    public static void registerConverter(ConverterRegistry registry) {
        registry.addConverter((Converter)new IsoOffsetDateTimeConverter());
    }
}

