/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.cache;

import java.util.function.Function;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.cache.CachingOperationInvoker;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInfo;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;

public class CachingOperationInvokerAdvisor
implements OperationMethodInvokerAdvisor {
    private final Function<String, Long> endpointIdTimeToLive;

    public CachingOperationInvokerAdvisor(Function<String, Long> endpointIdTimeToLive) {
        this.endpointIdTimeToLive = endpointIdTimeToLive;
    }

    @Override
    public OperationInvoker apply(String endpointId, OperationMethodInfo methodInfo, OperationInvoker invoker) {
        Long timeToLive;
        if (methodInfo.getOperationType() == OperationType.READ && methodInfo.getParameters().isEmpty() && (timeToLive = this.endpointIdTimeToLive.apply(endpointId)) != null && timeToLive > 0L) {
            return new CachingOperationInvoker(invoker, timeToLive);
        }
        return invoker;
    }
}

