/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.OperationFactory;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInfo;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.boot.actuate.endpoint.reflect.ReflectiveOperationInvoker;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;

class OperationsFactory<T extends Operation> {
    private static final Map<OperationType, Class<? extends Annotation>> OPERATION_TYPES;
    private final OperationFactory<T> operationFactory;
    private final ParameterMapper parameterMapper;
    private final Collection<OperationMethodInvokerAdvisor> invokerAdvisors;

    OperationsFactory(OperationFactory<T> operationFactory, ParameterMapper parameterMapper, Collection<? extends OperationMethodInvokerAdvisor> invokerAdvisors) {
        this.operationFactory = operationFactory;
        this.parameterMapper = parameterMapper;
        this.invokerAdvisors = invokerAdvisors == null ? Collections.emptyList() : new ArrayList<OperationMethodInvokerAdvisor>(invokerAdvisors);
    }

    public Map<Method, T> createOperations(String id, Object target, Class<?> type) {
        return MethodIntrospector.selectMethods(type, method -> this.createOperation(id, target, method));
    }

    private T createOperation(String endpointId, Object target, Method method) {
        return (T)((Operation)OPERATION_TYPES.entrySet().stream().map(entry -> this.createOperation(endpointId, target, method, (OperationType)((Object)((Object)entry.getKey())), (Class)entry.getValue())).filter(Objects::nonNull).findFirst().orElse(null));
    }

    private T createOperation(String endpointId, Object target, Method method, OperationType operationType, Class<? extends Annotation> annotationType) {
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)method, annotationType);
        if (annotationAttributes == null) {
            return null;
        }
        OperationMethodInfo methodInfo = new OperationMethodInfo(method, operationType, annotationAttributes);
        ReflectiveOperationInvoker invoker = new ReflectiveOperationInvoker(target, methodInfo, this.parameterMapper);
        return this.operationFactory.createOperation(endpointId, methodInfo, target, this.applyAdvisors(endpointId, methodInfo, invoker));
    }

    private OperationInvoker applyAdvisors(String endpointId, OperationMethodInfo methodInfo, OperationInvoker invoker) {
        if (this.invokerAdvisors != null) {
            for (OperationMethodInvokerAdvisor advisor : this.invokerAdvisors) {
                invoker = advisor.apply(endpointId, methodInfo, invoker);
            }
        }
        return invoker;
    }

    static {
        LinkedHashMap<OperationType, Class<DeleteOperation>> operationTypes = new LinkedHashMap<OperationType, Class<DeleteOperation>>();
        operationTypes.put(OperationType.READ, ReadOperation.class);
        operationTypes.put(OperationType.WRITE, WriteOperation.class);
        operationTypes.put(OperationType.DELETE, DeleteOperation.class);
        OPERATION_TYPES = Collections.unmodifiableMap(operationTypes);
    }
}

