/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.Collections;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.util.Assert;

public class EndpointInfo<T extends Operation> {
    private final String id;
    private final boolean enableByDefault;
    private final Collection<T> operations;

    public EndpointInfo(String id, boolean enableByDefault, Collection<T> operations) {
        Assert.hasText((String)id, (String)"ID must not be empty");
        Assert.notNull(operations, (String)"Operations must not be null");
        this.id = id;
        this.enableByDefault = enableByDefault;
        this.operations = Collections.unmodifiableCollection(operations);
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnableByDefault() {
        return this.enableByDefault;
    }

    public Collection<T> getOperations() {
        return this.operations;
    }
}

