/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.elasticsearch;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.indices.Stats;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ElasticsearchJestHealthIndicator
extends AbstractHealthIndicator {
    private final JestClient jestClient;
    private final JsonParser jsonParser = new JsonParser();

    public ElasticsearchJestHealthIndicator(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        JestResult aliases = this.jestClient.execute((Action)new Stats.Builder().build());
        JsonElement root = this.jsonParser.parse(aliases.getJsonString());
        JsonObject shards = root.getAsJsonObject().get("_shards").getAsJsonObject();
        int failedShards = shards.get("failed").getAsInt();
        if (failedShards != 0) {
            builder.outOfService();
        } else {
            builder.up();
        }
    }
}

