/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricMessage;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.messaging.MessageChannel;

public class MessageChannelMetricWriter
implements MetricWriter {
    private final MessageChannel channel;

    public MessageChannelMetricWriter(MessageChannel channel) {
        this.channel = channel;
    }

    @Override
    public void increment(Delta<?> delta) {
        this.channel.send(MetricMessage.forIncrement(delta));
    }

    @Override
    public void set(Metric<?> value) {
        this.channel.send(MetricMessage.forSet(value));
    }

    @Override
    public void reset(String metricName) {
        this.channel.send(MetricMessage.forReset(metricName));
    }
}

