/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.opentsdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.opentsdb.DefaultOpenTsdbNamingStrategy;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbData;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbNamingStrategy;
import org.springframework.boot.actuate.metrics.writer.GaugeWriter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class OpenTsdbGaugeWriter
implements GaugeWriter {
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final Log logger = LogFactory.getLog(OpenTsdbGaugeWriter.class);
    private RestOperations restTemplate;
    private String url = "http://localhost:4242/api/put";
    private int bufferSize = 64;
    private MediaType mediaType = MediaType.APPLICATION_JSON;
    private final List<OpenTsdbData> buffer = new ArrayList<OpenTsdbData>(this.bufferSize);
    private OpenTsdbNamingStrategy namingStrategy = new DefaultOpenTsdbNamingStrategy();

    public OpenTsdbGaugeWriter() {
        this(10000, 30000);
    }

    public OpenTsdbGaugeWriter(int connectTimeout, int readTimeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(connectTimeout);
        requestFactory.setReadTimeout(readTimeout);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    public RestOperations getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setNamingStrategy(OpenTsdbNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Metric<?> value) {
        OpenTsdbData data = new OpenTsdbData(this.namingStrategy.getName(value.getName()), (Number)value.getValue(), (Long)value.getTimestamp().getTime());
        List<OpenTsdbData> list = this.buffer;
        synchronized (list) {
            this.buffer.add(data);
            if (this.buffer.size() >= this.bufferSize) {
                this.flush();
            }
        }
    }

    public void flush() {
        List<OpenTsdbData> snapshot = this.getBufferSnapshot();
        if (snapshot.isEmpty()) {
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(this.mediaType));
        headers.setContentType(this.mediaType);
        ResponseEntity response = this.restTemplate.postForEntity(this.url, (Object)new HttpEntity(snapshot, (MultiValueMap)headers), Map.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            logger.warn((Object)("Cannot write metrics (discarded " + snapshot.size() + " values): " + response.getBody()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpenTsdbData> getBufferSnapshot() {
        List<OpenTsdbData> list = this.buffer;
        synchronized (list) {
            if (this.buffer.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<OpenTsdbData> snapshot = new ArrayList<OpenTsdbData>(this.buffer);
            this.buffer.clear();
            return snapshot;
        }
    }
}

