/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.boot.actuate.metrics.buffer.Buffer;
import org.springframework.lang.UsesJava8;

@UsesJava8
abstract class Buffers<B extends Buffer<?>> {
    private final ConcurrentHashMap<String, B> buffers = new ConcurrentHashMap();

    Buffers() {
    }

    public void forEach(final Predicate<String> predicate, final BiConsumer<String, B> consumer) {
        this.buffers.forEach(new BiConsumer<String, B>(){

            @Override
            public void accept(String name, B value) {
                if (predicate.test(name)) {
                    consumer.accept(name, value);
                }
            }
        });
    }

    public B find(String name) {
        return (B)((Buffer)this.buffers.get(name));
    }

    public int count() {
        return this.buffers.size();
    }

    protected final void doWith(String name, Consumer<B> consumer) {
        Buffer buffer = (Buffer)this.buffers.get(name);
        if (buffer == null) {
            buffer = (Buffer)this.buffers.computeIfAbsent(name, new Function<String, B>(){

                @Override
                public B apply(String name) {
                    return Buffers.this.createBuffer();
                }
            });
        }
        consumer.accept(buffer);
    }

    protected abstract B createBuffer();
}

