/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.audit;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class AuditEvent
implements Serializable {
    private final Date timestamp;
    private final String principal;
    private final String type;
    private final Map<String, Object> data;

    public AuditEvent(String principal, String type, Map<String, Object> data) {
        this(new Date(), principal, type, data);
    }

    public AuditEvent(String principal, String type, String ... data) {
        this(new Date(), principal, type, AuditEvent.convert(data));
    }

    public AuditEvent(Date timestamp, String principal, String type, Map<String, Object> data) {
        Assert.notNull((Object)timestamp, (String)"Timestamp must not be null");
        Assert.notNull((Object)principal, (String)"Principal must not be null");
        Assert.notNull((Object)type, (String)"Type must not be null");
        this.timestamp = timestamp;
        this.principal = principal;
        this.type = type;
        this.data = Collections.unmodifiableMap(data);
    }

    private static Map<String, Object> convert(String[] data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String entry : data) {
            if (entry.contains("=")) {
                int index = entry.indexOf("=");
                result.put(entry.substring(0, index), entry.substring(index + 1));
                continue;
            }
            result.put(entry, null);
        }
        return result;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String toString() {
        return "AuditEvent [timestamp=" + this.timestamp + ", principal=" + this.principal + ", type=" + this.type + ", data=" + this.data + "]";
    }
}

