/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.AbstractEndpointMvcAdapter;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.bind.RelaxedNames;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(prefix="endpoints.health")
public class HealthMvcEndpoint
extends AbstractEndpointMvcAdapter<HealthEndpoint>
implements EnvironmentAware {
    private final boolean secure;
    private Map<String, HttpStatus> statusMapping = new HashMap<String, HttpStatus>();
    private RelaxedPropertyResolver propertyResolver;
    private RelaxedPropertyResolver roleResolver;
    private long lastAccess = 0L;
    private Health cached;

    public HealthMvcEndpoint(HealthEndpoint delegate) {
        this(delegate, true);
    }

    public HealthMvcEndpoint(HealthEndpoint delegate, boolean secure) {
        super(delegate);
        this.secure = secure;
        this.setupDefaultStatusMapping();
    }

    private void setupDefaultStatusMapping() {
        this.addStatusMapping(Status.DOWN, HttpStatus.SERVICE_UNAVAILABLE);
        this.addStatusMapping(Status.OUT_OF_SERVICE, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public void setEnvironment(Environment environment) {
        this.propertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "endpoints.health.");
        this.roleResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "management.security.");
    }

    public void setStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping = new HashMap<String, HttpStatus>(statusMapping);
    }

    public void addStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping.putAll(statusMapping);
    }

    public void addStatusMapping(Status status, HttpStatus httpStatus) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.addStatusMapping(status.getCode(), httpStatus);
    }

    public void addStatusMapping(String statusCode, HttpStatus httpStatus) {
        Assert.notNull((Object)statusCode, (String)"StatusCode must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.statusMapping.put(statusCode, httpStatus);
    }

    @RequestMapping(produces={"application/json"})
    @ResponseBody
    public Object invoke(Principal principal) {
        if (!((HealthEndpoint)this.getDelegate()).isEnabled()) {
            return this.getDisabledResponse();
        }
        Health health = this.getHealth(principal);
        HttpStatus status = this.getStatus(health);
        if (status != null) {
            return new ResponseEntity((Object)health, status);
        }
        return health;
    }

    private HttpStatus getStatus(Health health) {
        String code = health.getStatus().getCode();
        if (code != null) {
            code = code.toLowerCase().replace("_", "-");
            for (String candidate : RelaxedNames.forCamelCase((String)code)) {
                HttpStatus status = this.statusMapping.get(candidate);
                if (status == null) continue;
                return status;
            }
        }
        return null;
    }

    private Health getHealth(Principal principal) {
        long accessTime = System.currentTimeMillis();
        if (this.isCacheStale(accessTime)) {
            this.lastAccess = accessTime;
            this.cached = ((HealthEndpoint)this.getDelegate()).invoke();
        }
        if (this.exposeHealthDetails(principal)) {
            return this.cached;
        }
        return Health.status(this.cached.getStatus()).build();
    }

    private boolean isCacheStale(long accessTime) {
        if (this.cached == null) {
            return true;
        }
        return accessTime - this.lastAccess >= ((HealthEndpoint)this.getDelegate()).getTimeToLive();
    }

    private boolean exposeHealthDetails(Principal principal) {
        return this.isSecure(principal) || this.isUnrestricted();
    }

    private boolean isSecure(Principal principal) {
        if (principal == null || principal.getClass().getName().contains("Anonymous")) {
            return false;
        }
        if (this.isSpringSecurityAuthentication(principal)) {
            Authentication authentication = (Authentication)principal;
            List<String> roles = Arrays.asList(StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)this.roleResolver.getProperty("roles", "ROLE_ADMIN"))));
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                String name = authority.getAuthority();
                for (String role : roles) {
                    if (!role.equals(name) && !("ROLE_" + role).equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSpringSecurityAuthentication(Principal principal) {
        return ClassUtils.isPresent((String)"org.springframework.security.core.Authentication", null) && principal instanceof Authentication;
    }

    private boolean isUnrestricted() {
        Boolean sensitive = (Boolean)this.propertyResolver.getProperty("sensitive", Boolean.class);
        return !this.secure && !Boolean.TRUE.equals(sensitive);
    }
}

