/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Condition;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="endpoints.autoconfig", ignoreUnknownFields=false)
public class AutoConfigurationReportEndpoint
extends AbstractEndpoint<Report> {
    @Autowired
    private ConditionEvaluationReport autoConfigurationReport;

    public AutoConfigurationReportEndpoint() {
        super("autoconfig");
    }

    @Override
    public Report invoke() {
        return new Report(this.autoConfigurationReport);
    }

    @JsonPropertyOrder(value={"condition", "message"})
    public static class MessageAndCondition {
        private final String condition;
        private final String message;

        public MessageAndCondition(ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome) {
            Condition condition = conditionAndOutcome.getCondition();
            ConditionOutcome outcome = conditionAndOutcome.getOutcome();
            this.condition = ClassUtils.getShortName(condition.getClass());
            this.message = StringUtils.hasLength((String)outcome.getMessage()) ? outcome.getMessage() : (outcome.isMatch() ? "matched" : "did not match");
        }

        public String getCondition() {
            return this.condition;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @JsonPropertyOrder(value={"positiveMatches", "negativeMatches", "exclusions"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Report {
        private MultiValueMap<String, MessageAndCondition> positiveMatches = new LinkedMultiValueMap();
        private MultiValueMap<String, MessageAndCondition> negativeMatches = new LinkedMultiValueMap();
        private List<String> exclusions;
        private Report parent;

        public Report(ConditionEvaluationReport report) {
            this.exclusions = report.getExclusions();
            for (Map.Entry entry : report.getConditionAndOutcomesBySource().entrySet()) {
                this.add(((ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue()).isFullMatch() ? this.positiveMatches : this.negativeMatches, (String)entry.getKey(), (ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue());
            }
            if (report.getParent() != null) {
                this.parent = new Report(report.getParent());
            }
        }

        private void add(MultiValueMap<String, MessageAndCondition> map, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            String name = ClassUtils.getShortName((String)source);
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                map.add((Object)name, (Object)new MessageAndCondition(conditionAndOutcome));
            }
        }

        public Map<String, List<MessageAndCondition>> getPositiveMatches() {
            return this.positiveMatches;
        }

        public Map<String, List<MessageAndCondition>> getNegativeMatches() {
            return this.negativeMatches;
        }

        public List<String> getExclusions() {
            return this.exclusions;
        }

        public Report getParent() {
            return this.parent;
        }
    }
}

