/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.util.StringUtils;

public abstract class AbstractMetricExporter
implements Exporter {
    private volatile AtomicBoolean processing = new AtomicBoolean(false);
    private Date earliestTimestamp = new Date();
    private boolean ignoreTimestamps = false;
    private final String prefix;

    public AbstractMetricExporter(String prefix) {
        this.prefix = !StringUtils.hasText((String)prefix) ? "" : (prefix.endsWith(".") ? prefix : prefix + ".");
    }

    public void setEarliestTimestamp(Date earliestTimestamp) {
        this.earliestTimestamp = earliestTimestamp;
    }

    public void setIgnoreTimestamps(boolean ignoreTimestamps) {
        this.ignoreTimestamps = ignoreTimestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() {
        if (!this.processing.compareAndSet(false, true)) {
            return;
        }
        try {
            for (String group : this.groups()) {
                ArrayList values = new ArrayList();
                for (Metric<?> metric : this.next(group)) {
                    Metric value = new Metric(this.prefix + metric.getName(), metric.getValue(), metric.getTimestamp());
                    Date timestamp = metric.getTimestamp();
                    if (!this.ignoreTimestamps && this.earliestTimestamp.after(timestamp)) continue;
                    values.add(value);
                }
                if (values.isEmpty()) continue;
                this.write(group, values);
            }
        }
        finally {
            this.processing.set(false);
        }
    }

    protected Iterable<String> groups() {
        return Collections.singleton("");
    }

    protected abstract void write(String var1, Collection<Metric<?>> var2);

    protected abstract Iterable<Metric<?>> next(String var1);
}

