/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class HealthMvcEndpoint
implements MvcEndpoint,
EnvironmentAware {
    private final HealthEndpoint delegate;
    private final boolean secure;
    private Map<String, HttpStatus> statusMapping = new HashMap<String, HttpStatus>();
    private RelaxedPropertyResolver propertyResolver;
    private long lastAccess = 0L;
    private Health cached;

    public HealthMvcEndpoint(HealthEndpoint delegate) {
        this(delegate, true);
    }

    public HealthMvcEndpoint(HealthEndpoint delegate, boolean secure) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.secure = secure;
        this.setupDefaultStatusMapping();
    }

    private void setupDefaultStatusMapping() {
        this.addStatusMapping(Status.DOWN, HttpStatus.SERVICE_UNAVAILABLE);
        this.addStatusMapping(Status.OUT_OF_SERVICE, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public void setEnvironment(Environment environment) {
        this.propertyResolver = new RelaxedPropertyResolver((PropertyResolver)environment, "endpoints.health.");
    }

    public void setStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping = new HashMap<String, HttpStatus>(statusMapping);
    }

    public void addStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping.putAll(statusMapping);
    }

    public void addStatusMapping(Status status, HttpStatus httpStatus) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.addStatusMapping(status.getCode(), httpStatus);
    }

    public void addStatusMapping(String statusCode, HttpStatus httpStatus) {
        Assert.notNull((Object)statusCode, (String)"StatusCode must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.statusMapping.put(statusCode, httpStatus);
    }

    @RequestMapping
    @ResponseBody
    public Object invoke(Principal principal) {
        if (!this.delegate.isEnabled()) {
            return new ResponseEntity(Collections.singletonMap("message", "This endpoint is disabled"), HttpStatus.NOT_FOUND);
        }
        Health health = this.getHealth(principal);
        HttpStatus status = this.statusMapping.get(health.getStatus().getCode());
        if (status != null) {
            return new ResponseEntity((Object)health, status);
        }
        return health;
    }

    private Health getHealth(Principal principal) {
        long accessTime = System.currentTimeMillis();
        if (this.isCacheStale(accessTime)) {
            this.lastAccess = accessTime;
            this.cached = this.delegate.invoke();
        }
        if (this.exposeHealthDetails(principal)) {
            return this.cached;
        }
        return Health.status(this.cached.getStatus()).build();
    }

    private boolean isCacheStale(long accessTime) {
        if (this.cached == null) {
            return true;
        }
        return accessTime - this.lastAccess >= this.delegate.getTimeToLive();
    }

    private boolean exposeHealthDetails(Principal principal) {
        return this.isSecure(principal) || this.isUnrestricted();
    }

    private boolean isSecure(Principal principal) {
        return principal != null && !principal.getClass().getName().contains("Anonymous");
    }

    private boolean isUnrestricted() {
        Boolean sensitive = (Boolean)this.propertyResolver.getProperty("sensitive", Boolean.class);
        return !this.secure || Boolean.FALSE.equals(sensitive);
    }

    @Override
    public String getPath() {
        return "/" + this.delegate.getId();
    }

    @Override
    public boolean isSensitive() {
        return this.delegate.isSensitive();
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return this.delegate.getClass();
    }
}

