/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public final class MetricWriterMessageHandler
implements MessageHandler {
    private final MetricWriter observer;

    public MetricWriterMessageHandler(MetricWriter observer) {
        this.observer = observer;
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        Object payload = message.getPayload();
        if (payload instanceof Delta) {
            Delta value = (Delta)payload;
            this.observer.increment(value);
        } else {
            Metric value = (Metric)payload;
            this.observer.set(value);
        }
    }
}

