/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.util.Assert;

public class CompositeHealthIndicator
implements HealthIndicator {
    private final Map<String, HealthIndicator> indicators;
    private final HealthAggregator healthAggregator;

    public CompositeHealthIndicator(HealthAggregator healthAggregator) {
        this(healthAggregator, new LinkedHashMap<String, HealthIndicator>());
    }

    public CompositeHealthIndicator(HealthAggregator healthAggregator, Map<String, HealthIndicator> indicators) {
        Assert.notNull((Object)healthAggregator, (String)"HealthAggregator must not be null");
        Assert.notNull((Object)healthAggregator, (String)"Indicators must not be null");
        this.indicators = new LinkedHashMap<String, HealthIndicator>(indicators);
        this.healthAggregator = healthAggregator;
    }

    public void addHealthIndicator(String name, HealthIndicator indicator) {
        this.indicators.put(name, indicator);
    }

    @Override
    public Health health() {
        LinkedHashMap<String, Health> healths = new LinkedHashMap<String, Health>();
        for (Map.Entry<String, HealthIndicator> entry : this.indicators.entrySet()) {
            healths.put(entry.getKey(), entry.getValue().health());
        }
        return this.healthAggregator.aggregate(healths);
    }
}

