/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.trace.Trace;
import org.springframework.boot.actuate.trace.TraceRepository;

public class InMemoryTraceRepository
implements TraceRepository {
    private int capacity = 100;
    private final List<Trace> traces = new ArrayList<Trace>();

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Trace> findAll() {
        List<Trace> list = this.traces;
        synchronized (list) {
            return Collections.unmodifiableList(this.traces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Map<String, Object> map) {
        Trace trace = new Trace(new Date(), map);
        List<Trace> list = this.traces;
        synchronized (list) {
            while (this.traces.size() >= this.capacity) {
                this.traces.remove(0);
            }
            this.traces.add(trace);
        }
    }
}

