/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;

public class MessageChannelMetricWriter
implements MetricWriter {
    private static final String METRIC_NAME = "metricName";
    private final String DELETE = "delete";
    private final MessageChannel channel;

    public MessageChannelMetricWriter(MessageChannel channel) {
        this.channel = channel;
    }

    @Override
    public void increment(Delta<?> delta) {
        this.channel.send(MessageBuilder.withPayload(delta).setHeader(METRIC_NAME, (Object)delta.getName()).build());
    }

    @Override
    public void set(Metric<?> value) {
        this.channel.send(MessageBuilder.withPayload(value).setHeader(METRIC_NAME, (Object)value.getName()).build());
    }

    @Override
    public void reset(String metricName) {
        this.channel.send(MessageBuilder.withPayload((Object)this.DELETE).setHeader(METRIC_NAME, (Object)metricName).build());
    }
}

