/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.repository.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.repository.redis.RedisUtils;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;

public class RedisMultiMetricRepository
implements MultiMetricRepository {
    private static final String DEFAULT_METRICS_PREFIX = "spring.groups.";
    private String prefix = "spring.groups.";
    private String keys = this.prefix + "keys";
    private final BoundZSetOperations<String, String> zSetOperations;
    private final RedisOperations<String, String> redisOperations;

    public RedisMultiMetricRepository(RedisConnectionFactory redisConnectionFactory) {
        Assert.notNull((Object)redisConnectionFactory, (String)"RedisConnectionFactory must not be null");
        this.redisOperations = RedisUtils.stringTemplate(redisConnectionFactory);
        this.zSetOperations = this.redisOperations.boundZSetOps((Object)this.keys);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.keys = this.prefix + "keys";
    }

    @Override
    public Iterable<Metric<?>> findAll(String metricNamePrefix) {
        BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)this.keyFor(metricNamePrefix));
        Set keys = zSetOperations.range(0L, -1L);
        Iterator keysIt = keys.iterator();
        ArrayList result = new ArrayList(keys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)keys);
        for (String v : values) {
            result.add(this.deserialize((String)keysIt.next(), v));
        }
        return result;
    }

    @Override
    public void save(String group, Collection<Metric<?>> values) {
        String groupKey = this.keyFor(group);
        this.trackMembership(groupKey);
        BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)groupKey);
        for (Metric<?> metric : values) {
            String raw = this.serialize(metric);
            String key = this.keyFor(metric.getName());
            zSetOperations.add((Object)key, 0.0);
            this.redisOperations.opsForValue().set((Object)key, (Object)raw);
        }
    }

    @Override
    public Iterable<String> groups() {
        Set range = this.zSetOperations.range(0L, -1L);
        ArrayList<String> result = new ArrayList<String>();
        for (String key : range) {
            result.add(this.nameFor(key));
        }
        return range;
    }

    @Override
    public long count() {
        return this.zSetOperations.size();
    }

    @Override
    public void reset(String group) {
        String groupKey = this.keyFor(group);
        if (this.redisOperations.hasKey((Object)groupKey).booleanValue()) {
            BoundZSetOperations zSetOperations = this.redisOperations.boundZSetOps((Object)groupKey);
            Set keys = zSetOperations.range(0L, -1L);
            for (String key : keys) {
                this.redisOperations.delete((Object)key);
            }
            this.redisOperations.delete((Object)groupKey);
        }
        this.zSetOperations.remove(new Object[]{groupKey});
    }

    private Metric<?> deserialize(String redisKey, String v) {
        String[] vals = v.split("@");
        Double value = Double.valueOf(vals[0]);
        Date timestamp = vals.length > 1 ? new Date(Long.valueOf(vals[1])) : new Date();
        return new Metric<Double>(this.nameFor(redisKey), value, timestamp);
    }

    private String serialize(Metric<?> entity) {
        return String.valueOf(entity.getValue() + "@" + entity.getTimestamp().getTime());
    }

    private String keyFor(String name) {
        return this.prefix + name;
    }

    private String nameFor(String redisKey) {
        Assert.state((redisKey != null && redisKey.startsWith(this.prefix) ? 1 : 0) != 0, (String)("Invalid key does not start with prefix: " + redisKey));
        return redisKey.substring(this.prefix.length());
    }

    private void trackMembership(String redisKey) {
        this.zSetOperations.add((Object)redisKey, 0.0);
    }
}

