/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.trace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.actuate.web.BasicErrorController;
import org.springframework.core.Ordered;

public class WebRequestTraceFilter
implements Filter,
Ordered {
    private final Log logger = LogFactory.getLog(WebRequestTraceFilter.class);
    private boolean dumpRequests = false;
    private final TraceRepository traceRepository;
    private int order = Integer.MAX_VALUE;
    private ObjectMapper objectMapper = new ObjectMapper();
    private BasicErrorController errorController;

    public WebRequestTraceFilter(TraceRepository traceRepository) {
        this.traceRepository = traceRepository;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setDumpRequests(boolean dumpRequests) {
        this.dumpRequests = dumpRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Map<String, Object> trace = this.getTrace(request);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Processing request " + request.getMethod() + " " + request.getRequestURI()));
            if (this.dumpRequests) {
                try {
                    Map headers = (Map)trace.get("headers");
                    this.logger.trace((Object)("Headers: " + this.objectMapper.writeValueAsString((Object)headers)));
                }
                catch (JsonProcessingException ex) {
                    throw new IllegalStateException("Cannot create JSON", ex);
                }
            }
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.enhanceTrace(trace, response);
            this.traceRepository.add(trace);
        }
    }

    protected void enhanceTrace(Map<String, Object> trace, HttpServletResponse response) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (String header : response.getHeaderNames()) {
            String value = response.getHeader(header);
            headers.put(header, value);
        }
        headers.put("status", "" + response.getStatus());
        Map allHeaders = (Map)trace.get("headers");
        allHeaders.put("response", headers);
    }

    protected Map<String, Object> getTrace(HttpServletRequest request) {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = Collections.list(request.getHeaders(name));
            Object value = values;
            if (values.size() == 1) {
                value = values.get(0);
            } else if (values.isEmpty()) {
                value = "";
            }
            headers.put(name, value);
        }
        LinkedHashMap<String, Object> trace = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, LinkedHashMap<String, Object>> allHeaders = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        allHeaders.put("request", headers);
        trace.put("method", request.getMethod());
        trace.put("path", request.getRequestURI());
        trace.put("headers", allHeaders);
        Throwable error = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (error != null && this.errorController != null) {
            trace.put("error", this.errorController.error(request));
        }
        return trace;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void setErrorController(BasicErrorController errorController) {
        this.errorController = errorController;
    }
}

