/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(name="shell", ignoreUnknownFields=true)
public class CrshProperties {
    protected static final String CRASH_AUTH = "crash.auth";
    protected static final String CRASH_AUTH_JAAS_DOMAIN = "crash.auth.jaas.domain";
    protected static final String CRASH_AUTH_KEY_PATH = "crash.auth.key.path";
    protected static final String CRASH_AUTH_SIMPLE_PASSWORD = "crash.auth.simple.password";
    protected static final String CRASH_AUTH_SIMPLE_USERNAME = "crash.auth.simple.username";
    protected static final String CRASH_AUTH_SPRING_ROLES = "crash.auth.spring.roles";
    protected static final String CRASH_SSH_KEYPATH = "crash.ssh.keypath";
    protected static final String CRASH_SSH_PORT = "crash.ssh.port";
    protected static final String CRASH_TELNET_PORT = "crash.telnet.port";
    protected static final String CRASH_VFS_REFRESH_PERIOD = "crash.vfs.refresh_period";
    private String auth = "simple";
    @Autowired(required=false)
    private AuthenticationProperties authenticationProperties = new SimpleAuthenticationProperties();
    private int commandRefreshInterval = -1;
    private String[] commandPathPatterns = new String[]{"classpath*:/commands/**", "classpath*:/crash/commands/**"};
    private String[] configPathPatterns = new String[]{"classpath*:/crash/*"};
    private String[] disabledPlugins = new String[0];
    private Ssh ssh = new Ssh();
    private Telnet telnet = new Telnet();

    public String getAuth() {
        return this.auth;
    }

    public AuthenticationProperties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    public int getCommandRefreshInterval() {
        return this.commandRefreshInterval;
    }

    public String[] getCommandPathPatterns() {
        return this.commandPathPatterns;
    }

    public String[] getConfigPathPatterns() {
        return this.configPathPatterns;
    }

    public String[] getDisabledPlugins() {
        return this.disabledPlugins;
    }

    public Ssh getSsh() {
        return this.ssh;
    }

    public Telnet getTelnet() {
        return this.telnet;
    }

    public Properties mergeProperties(Properties properties) {
        properties = this.ssh.mergeProperties(properties);
        properties = this.telnet.mergeProperties(properties);
        properties.put(CRASH_AUTH, this.auth);
        if (this.authenticationProperties != null) {
            properties = this.authenticationProperties.mergeProperties(properties);
        }
        if (this.commandRefreshInterval > 0) {
            properties.put(CRASH_VFS_REFRESH_PERIOD, String.valueOf(this.commandRefreshInterval));
        }
        ArrayList<String> dp = new ArrayList<String>(Arrays.asList(this.disabledPlugins));
        if (!this.ssh.isEnabled()) {
            dp.add("org.crsh.ssh.SSHPlugin");
        }
        if (!this.telnet.isEnabled()) {
            dp.add("org.crsh.telnet.TelnetPlugin");
        }
        this.disabledPlugins = dp.toArray(new String[dp.size()]);
        return properties;
    }

    public void setAuth(String auth) {
        Assert.hasLength((String)auth);
        this.auth = auth;
    }

    public void setAuthenticationProperties(AuthenticationProperties authenticationProperties) {
        Assert.notNull((Object)authenticationProperties);
        this.authenticationProperties = authenticationProperties;
    }

    public void setCommandRefreshInterval(int commandRefreshInterval) {
        this.commandRefreshInterval = commandRefreshInterval;
    }

    public void setCommandPathPatterns(String[] commandPathPatterns) {
        Assert.notEmpty((Object[])commandPathPatterns);
        this.commandPathPatterns = commandPathPatterns;
    }

    public void setConfigPathPatterns(String[] configPathPatterns) {
        Assert.notEmpty((Object[])configPathPatterns);
        this.configPathPatterns = configPathPatterns;
    }

    public void setDisabledPlugins(String[] disabledPlugins) {
        Assert.notEmpty((Object[])disabledPlugins);
        this.disabledPlugins = disabledPlugins;
    }

    public void setSsh(Ssh ssh) {
        Assert.notNull((Object)ssh);
        this.ssh = ssh;
    }

    public void setTelnet(Telnet telnet) {
        Assert.notNull((Object)telnet);
        this.telnet = telnet;
    }

    public static class Telnet
    implements PropertiesProvider {
        private boolean enabled = false;
        private String port = "5000";

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Properties mergeProperties(Properties properties) {
            if (this.enabled) {
                properties.put(CrshProperties.CRASH_TELNET_PORT, this.port);
            }
            return properties;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPort(Integer port) {
            Assert.notNull((Object)port);
            this.port = port.toString();
        }
    }

    public static class Ssh
    implements PropertiesProvider {
        private boolean enabled = true;
        private String keyPath = null;
        private String port = "2000";

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public Properties mergeProperties(Properties properties) {
            if (this.enabled) {
                properties.put(CrshProperties.CRASH_SSH_PORT, this.port);
                if (this.keyPath != null) {
                    properties.put(CrshProperties.CRASH_SSH_KEYPATH, this.keyPath);
                }
            }
            return properties;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeyPath(String keyPath) {
            Assert.hasText((String)keyPath);
            this.keyPath = keyPath;
        }

        public void setPort(Integer port) {
            Assert.notNull((Object)port);
            this.port = port.toString();
        }
    }

    @ConfigurationProperties(name="shell.auth.spring", ignoreUnknownFields=false)
    public static class SpringAuthenticationProperties
    implements AuthenticationProperties {
        private String[] roles = new String[]{"ROLE_ADMIN"};

        @Override
        public Properties mergeProperties(Properties properties) {
            if (this.roles != null) {
                properties.put(CrshProperties.CRASH_AUTH_SPRING_ROLES, StringUtils.arrayToCommaDelimitedString((Object[])this.roles));
            }
            return properties;
        }

        public void setRoles(String[] roles) {
            Assert.notNull((Object)roles);
            this.roles = roles;
        }
    }

    @ConfigurationProperties(name="shell.auth.simple", ignoreUnknownFields=false)
    public static class SimpleAuthenticationProperties
    implements AuthenticationProperties {
        private static Log logger = LogFactory.getLog(SimpleAuthenticationProperties.class);
        private String username = "user";
        private String password = UUID.randomUUID().toString();
        private boolean defaultPassword = true;

        public boolean isDefaultPassword() {
            return this.defaultPassword;
        }

        @Override
        public Properties mergeProperties(Properties properties) {
            properties.put(CrshProperties.CRASH_AUTH_SIMPLE_USERNAME, this.username);
            properties.put(CrshProperties.CRASH_AUTH_SIMPLE_PASSWORD, this.password);
            if (this.defaultPassword) {
                logger.info((Object)("\n\nUsing default password for shell access: " + this.password + "\n\n"));
            }
            return properties;
        }

        public void setPassword(String password) {
            if (password.startsWith("${") && password.endsWith("}") || !StringUtils.hasLength((String)password)) {
                return;
            }
            this.password = password;
            this.defaultPassword = false;
        }

        public void setUsername(String username) {
            Assert.hasLength((String)username);
            this.username = username;
        }
    }

    public static interface PropertiesProvider {
        public Properties mergeProperties(Properties var1);
    }

    @ConfigurationProperties(name="shell.auth.key", ignoreUnknownFields=false)
    public static class KeyAuthenticationProperties
    implements AuthenticationProperties {
        private String path;

        @Override
        public Properties mergeProperties(Properties properties) {
            if (this.path != null) {
                properties.put(CrshProperties.CRASH_AUTH_KEY_PATH, this.path);
            }
            return properties;
        }

        public void setPath(String path) {
            Assert.hasText((String)path);
            this.path = path;
        }
    }

    @ConfigurationProperties(name="shell.auth.jaas", ignoreUnknownFields=false)
    public static class JaasAuthenticationProperties
    implements AuthenticationProperties {
        private String domain = "my-domain";

        @Override
        public Properties mergeProperties(Properties properties) {
            properties.put(CrshProperties.CRASH_AUTH_JAAS_DOMAIN, this.domain);
            return properties;
        }

        public void setDomain(String domain) {
            Assert.hasText((String)domain);
            this.domain = domain;
        }
    }

    public static interface AuthenticationProperties
    extends PropertiesProvider {
    }
}

