/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.boot.actuate.metrics.Measurement;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.MetricRepository;

public class InMemoryMetricRepository
implements MetricRepository {
    private ConcurrentMap<String, Measurement> metrics = new ConcurrentHashMap<String, Measurement>();
    private ConcurrentMap<String, Object> locks = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(String metricName, int amount, Date timestamp) {
        Object lock = this.locks.putIfAbsent(metricName, new Object());
        if (lock == null) {
            lock = this.locks.get(metricName);
        }
        Object object = lock;
        synchronized (object) {
            Measurement current = (Measurement)this.metrics.get(metricName);
            if (current != null) {
                Metric metric = current.getMetric();
                this.metrics.replace(metricName, current, new Measurement(timestamp, metric.increment(amount)));
                return;
            }
            this.metrics.putIfAbsent(metricName, new Measurement(timestamp, new Metric(metricName, amount)));
        }
    }

    @Override
    public void set(String metricName, double value, Date timestamp) {
        Measurement current = (Measurement)this.metrics.get(metricName);
        if (current != null) {
            Metric metric = current.getMetric();
            this.metrics.replace(metricName, current, new Measurement(timestamp, metric.set(value)));
        } else {
            this.metrics.putIfAbsent(metricName, new Measurement(timestamp, new Metric(metricName, value)));
        }
    }

    @Override
    public void delete(String metricName) {
        this.metrics.remove(metricName);
    }

    @Override
    public Metric findOne(String metricName) {
        if (this.metrics.containsKey(metricName)) {
            return ((Measurement)this.metrics.get(metricName)).getMetric();
        }
        return new Metric(metricName, 0.0);
    }

    @Override
    public Collection<Metric> findAll() {
        ArrayList<Metric> result = new ArrayList<Metric>();
        for (Measurement measurement : this.metrics.values()) {
            result.add(measurement.getMetric());
        }
        return result;
    }
}

