/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics;

import java.util.Date;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.MetricRepository;

public class DefaultCounterService
implements CounterService {
    private MetricRepository repository;

    public DefaultCounterService(MetricRepository repository) {
        this.repository = repository;
    }

    @Override
    public void increment(String metricName) {
        this.repository.increment(this.wrap(metricName), 1, new Date());
    }

    @Override
    public void decrement(String metricName) {
        this.repository.increment(this.wrap(metricName), -1, new Date());
    }

    @Override
    public void reset(String metricName) {
        this.repository.set(this.wrap(metricName), 0.0, new Date());
    }

    private String wrap(String metricName) {
        if (metricName.startsWith("counter")) {
            return metricName;
        }
        return "counter." + metricName;
    }
}

